#!/usr/bin/perl
#	 License: GPLv2
#	--MikeeUSA--
$CONVERT_SOME_NOISES_TO_SIMPLER_STRING = 1;
#
$mode = 0; #1= lights
$DEBUGPRINTS = 0;
$TESTLIGHTPRINTS = 0;
$TESTUNKNOWNPRINTS = 1;
$IGNOREPATHNODES = 1;
$IGNORELEVELINFO = 1;
$IGNOREZONEINFO = 1;
$PRINTORIGINALSOUNDINFOASCOMMENTIFCONVERTED = 1;
$PRINTORIGINALROTATIONINFOASCOMMENTIFCONVERTED = 1;
$COMMENTOUTUNKNOWNSIFTESTUNKNOWNPRINTS = 1;
$NEWLINEBETWEENSECTIONS = 2;
$comment_oldclassname_for_all = 1;
$ENABLE_ADD_Z_TOPLAYERSTART = 1;
$add_z_toplayerstart = 64; #helps keep out of solid
$PRINTINFOREGARDINGADDINGZTOPLAYERSTART = 1; #print the info regarding adding Z to player start, ie print the original as a comment
$PRINTORIGINALHUESATURATIONBRIGHTNESSINFOASCOMMENTIFCONVERTED = 1;
$rtlight_radius_scale = 10; #for some 10 seems good, for other maps 5...
$SET_UNSET_LIGHT_COLOR = 1;
$SET_UNSET_LIGHT_RADIUS = 1;
$PRINTCOMMANDARGUMENTSFORRTLIGHTS = 1;
#
$ORIGINFORUNKNOWNSIFTESTUNKNOWNPRINTS = 1; #can be 1 or 2
#
$STRICTFILECONTROL = 1;

sub newlinebetweensections {
		if ($comment_oldclassname_for_all) {
			if ($originalclassname) {
				print('//'); print('#'); print("$originalclassname"); print("\n");
			}
		}
		if ($NEWLINEBETWEENSECTIONS) {
			if ($NEWLINEBETWEENSECTIONS > 10) {
				print("\n");
			} else {
				print("\n" x $NEWLINEBETWEENSECTIONS);
			}
		}
}

#sub rotation_for_obj_from_mc ($x)
#{
#	return (((65536 - $x) / 65536) * 360);
#}

sub unr_rotation_to_deg #($x)
{	my $x = $_[0]; #had to add
	return (($x) * (360 / 65535));
}

sub rotation_convert #($unrnum) 
{	my $unrnum = $_[0]; #had to add
	my $v;
	$v = &unr_rotation_to_deg ($unrnum);
	if ($v > 180) { $v -= 360; }
	if ($v < -180) { $v += 360; }
	return $v;
}


#test_hsv_to_rgb();
sub test_hsv_to_rgb {
	#$hue 		= 28;
	#$saturation	= 32;
	#$brightness	= 96;
	$hue 		= 28;
	$saturation	= 255;
	$brightness	= 128;
	print("H $hue  S $saturation  B $brightness\n");
	hsv_to_rgb();
	print("$color_r $color_g $color_b\n");
	print($color_r*256,' ', $color_g*256,' ',  $color_b*256,' ',  "\n");
	print(abs(-100),"\n");
	exit;
}

#sub max ($$) { $_[$_[0] < $_[1]] }
sub min ($$) { $_[$_[0] > $_[1]] }

$hsvalgo = 0;

sub hsv_to_rgb 
{
	hsv_to_rgb_experiment5();
}

#sub hsv_to_rgb
sub hsv_to_rgb_experiment2 #trying with 240 value
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	
	#added
	if ($hue < 0) { $hue = (240 - $hue) % 240; }
	else { $hue = $hue % 240; }
	#added

	#Different way
	if ($hue < 80) {
		$color_r = min(255, 255 * (80 - $hue) / 40);
	} elsif ($hue > 160) {
		$color_r = min(255, 255 * ($hue - 160) / 40);
	}
	
	if ($hue < 160) {
		$color_g = min(255, 255 * (80 - abs($hue - 80)) / 40);
	}
	
	if ($hue > 80) {
		$color_b = min(255, 255 * (80 - abs($hue - 160)) / 40);
	}
	#Different way
			
	#if ($saturation < 240) {
	#	$color_r = $color_r * ($saturation / 240);
	#	$color_g = $color_g * ($saturation / 240);
	#	$color_b = $color_b * ($saturation / 240);
	#	$offset_saturation = 128 * (240 - $saturation) / 240;
	#	$color_r += $offset_saturation;
	#	$color_g += $offset_saturation;
	#	$color_b += $offset_saturation;
	#}
	
	#Different way
	#$brightness = min(255, $brightness);
	#$color_r = $color_r * ((120 - abs($brightness - 120)) / 120);
	#$color_g = $color_g * ((120 - abs($brightness - 120)) / 120);
	#$color_b = $color_b * ((120 - abs($brightness - 120)) / 120);
	

	#if ($brightness > 120) {
	#	$offset_brightness = 256 * ($brightness - 120) / 120;
	#	$color_r += $offset_brightness;
	#	$color_g += $offset_brightness;
	#	$color_b += $offset_brightness;
	#}
	##Different way
	
	$color_r = $color_r / 256;
	$color_g = $color_g / 256;
	$color_b = $color_b / 256;
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}


sub hsv_to_rgb_experiment #trying with 240 value
			#1: try switching r and g
			#2: try switching r b and r after
			#2: try switching b and g after
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	
	#added
	if ($hue < 0) { $hue = (240 - $hue) % 240; }
	else { $hue = $hue % 240; }
	#added

	#Different way
	if ($hue < 80) {
		$color_b = min(255, 255 * (80 - $hue) / 40);
	} elsif ($hue > 160) {
		$color_b = min(255, 255 * ($hue - 160) / 40);
	}
	
	if ($hue < 160) {
		$color_g = min(255, 255 * (80 - abs($hue - 80)) / 40);
	}
	
	if ($hue > 80) {
		$color_r = min(255, 255 * (80 - abs($hue - 160)) / 40);
	}
	#Different way
			
	if ($saturation < 240) {
		$color_r = $color_r * ($saturation / 240);
		$color_g = $color_g * ($saturation / 240);
		$color_b = $color_b * ($saturation / 240);
		$offset_saturation = 128 * (240 - $saturation) / 240;
		$color_r += $offset_saturation;
		$color_g += $offset_saturation;
		$color_b += $offset_saturation;
	}
	
	#Different way
	$brightness = min(255, $brightness);
	$color_r = $color_r * ((120 - abs($brightness - 120)) / 120);
	$color_g = $color_g * ((120 - abs($brightness - 120)) / 120);
	$color_b = $color_b * ((120 - abs($brightness - 120)) / 120);
	

	if ($brightness > 120) {
		$offset_brightness = 256 * ($brightness - 120) / 120;
		$color_r += $offset_brightness;
		$color_g += $offset_brightness;
		$color_b += $offset_brightness;
	}
	#Different way
	
	$color_r = $color_r / 256;
	$color_g = $color_g / 256;
	$color_b = $color_b / 256;
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}
sub hsv_to_rgb_experiment5{
	$hue = ($hue / 85);
	if ($hue <= 1) { $color_g = $hue; $color_r = (1 - $color_g); $color_b = 0; }
	elsif ($hue <= 2) { $color_b = ($hue - 1); $color_g = (1 - $color_b); $color_r = 0; }
	else { $color_red = ($hue - 2); $color_b = (1-$color_r); $color_g=0; }
	
	#0 = full color
	#255 all white
	#if the color is 1:
	# algo is 1*((255-X)/255)
	#1*((255-1)/255)   
	#	= ~0.99607843137254901961
	#1*((255-255)/255) 
	#	=  0
	#1*((255-128)/255) 
	#	= ~0.49803921568627450980
	#if ($saturation > 0) { 
	#	$color_r = $color_r * ((255-$saturation)/255);
	#	$color_g = $color_g * ((255-$saturation)/255);
	#	$color_b = $color_b * ((255-$saturation)/255);
	#}
	#if ($saturation > 0) { 
	#	$color_r = $color_r * ($saturation / 255);
	#	$color_g = $color_g * ($saturation / 255);
	#	$color_b = $color_b * ($saturation / 255);
	#
	#}
	
	#
	#0 brighness is dark seems to be
	#255 is full color seems to be
	#if ($brightness < 255) {
	#
	#}
	
	#if ($saturation < 255) {
	#	$color_r = $color_r * ($saturation / 255);
	#	$color_g = $color_g * ($saturation / 255);
	#	$color_b = $color_b * ($saturation / 255);
	#	$offset_saturation = 128 * (255 - $saturation) / 255;
	#	$color_r += $offset_saturation / 255;
	#	$color_g += $offset_saturation / 255;
	#	$color_b += $offset_saturation / 255;
	#}
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);
}

#sub hsv_to_rgb
sub hsv_to_rgb_std #trying with 240 value
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	
	#added
	if ($hue < 0) { $hue = (240 - $hue) % 240; }
	else { $hue = $hue % 240; }
	#added

	#Different way
	if ($hue < 80) {
		$color_r = min(255, 255 * (80 - $hue) / 40);
	} elsif ($hue > 160) {
		$color_r = min(255, 255 * ($hue - 160) / 40);
	}
	
	if ($hue < 160) {
		$color_g = min(255, 255 * (80 - abs($hue - 80)) / 40);
	}
	
	if ($hue > 80) {
		$color_b = min(255, 255 * (80 - abs($hue - 160)) / 40);
	}
	#Different way
			
	if ($saturation < 240) {
		$color_r = $color_r * ($saturation / 240);
		$color_g = $color_g * ($saturation / 240);
		$color_b = $color_b * ($saturation / 240);
		$offset_saturation = 128 * (240 - $saturation) / 240;
		$color_r += $offset_saturation;
		$color_g += $offset_saturation;
		$color_b += $offset_saturation;
	}
	
	#Different way
	$brightness = min(255, $brightness);
	$color_r = $color_r * ((120 - abs($brightness - 120)) / 120);
	$color_g = $color_g * ((120 - abs($brightness - 120)) / 120);
	$color_b = $color_b * ((120 - abs($brightness - 120)) / 120);
	

	if ($brightness > 120) {
		$offset_brightness = 256 * ($brightness - 120) / 120;
		$color_r += $offset_brightness;
		$color_g += $offset_brightness;
		$color_b += $offset_brightness;
	}
	#Different way
	
	$color_r = $color_r / 256;
	$color_g = $color_g / 256;
	$color_b = $color_b / 256;
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}


sub hsv_to_rgbanothertry #too green
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	
	#Different way
	if ($hue < 85) {
		$color_r = min(255, 255 * (85 - $hue) / 42.5);
	} elsif ($hue > 170) {
		$color_r = min(255, 255 * ($hue - 170) / 42.5);
	}
	
	if ($hue < 170) {
		$color_g = min(255, 255 * (85 - abs($hue - 85)) / 42.5);
	}
	
	if ($hue > 85) {
		$color_b = min(255, 255 * (85 - abs($hue - 170)) / 42.5);
	}
	#Different way
			
	if ($saturation < 255) {
		$color_r = $color_r * ($saturation / 255);
		$color_g = $color_g * ($saturation / 255);
		$color_b = $color_b * ($saturation / 255);
		$offset_saturation = 128 * (255 - $saturation) / 255;
		$color_r += $offset_saturation;
		$color_g += $offset_saturation;
		$color_b += $offset_saturation;
	}
	
	#Different way
	$brightness = min(255, $brightness);
	$color_r = $color_r * ((120 - abs($brightness - 120)) / 120);
	$color_g = $color_g * ((120 - abs($brightness - 120)) / 120);
	$color_b = $color_b * ((120 - abs($brightness - 120)) / 120);
	

	if ($brightness > 120) {
		$offset_brightness = 256 * ($brightness - 120) / 120;
		$color_r += $offset_brightness;
		$color_g += $offset_brightness;
		$color_b += $offset_brightness;
	}
	#Different way
	
	$color_r = $color_r / 256;
	$color_g = $color_g / 256;
	$color_b = $color_b / 256;
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}
sub hsv_to_rgbprev #ok, not as blue as supposed to
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	
	#Different way
	if ($hue < 80) {
		$color_r = min(255, 255 * (80 - $hue) / 40);
	} elsif ($hue > 160) {
		$color_r = min(255, 255 * ($hue - 160) / 40);
	}
	
	if ($hue < 160) {
		$color_g = min(255, 255 * (80 - abs($hue - 80)) / 40);
	}
	
	if ($hue > 80) {
		$color_b = min(255, 255 * (80 - abs($hue - 160)) / 40);
	}
	#Different way
			
	if ($saturation < 255) {
		$color_r = $color_r * ($saturation / 255);
		$color_g = $color_g * ($saturation / 255);
		$color_b = $color_b * ($saturation / 255);
		$offset_saturation = 128 * (255 - $saturation) / 255;
		$color_r += $offset_saturation;
		$color_g += $offset_saturation;
		$color_b += $offset_saturation;
	}
	
	#Different way
	$brightness = min(255, $brightness);
	$color_r = $color_r * ((120 - abs($brightness - 120)) / 120);
	$color_g = $color_g * ((120 - abs($brightness - 120)) / 120);
	$color_b = $color_b * ((120 - abs($brightness - 120)) / 120);
	

	if ($brightness > 120) {
		$offset_brightness = 256 * ($brightness - 120) / 120;
		$color_r += $offset_brightness;
		$color_g += $offset_brightness;
		$color_b += $offset_brightness;
	}
	#Different way
	
	$color_r = $color_r / 256;
	$color_g = $color_g / 256;
	$color_b = $color_b / 256;
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}


sub althsv_to_rgb
{	my $offset_saturation = 0;
	$color_r = 0; $color_g = 0; $color_b = 0;
	#$hue 		#H
	#$saturation	#S
	#$brightness	#L
	$saturation = 255 - $saturation; #Tried
	
	if ($hue < 85) {
		$color_r = min(1, (85 - $hue) / 42.5);
	} elsif ($hue > 170) {
		$color_r = min(1, ($hue - 170) / 42.5);
	}
				
	if ($hue < 170) {
		$color_g = min(1, (85 - abs($hue - 85)) / 42.5);
	}
					
	if ($hue > 85) {
		$color_b = min(1, (85 - abs($hue - 170)) / 42.5);
	}

	
	if ($saturation < 255) {
		$color_r = $color_r * ($saturation / 255);
		$color_g = $color_g * ($saturation / 255);
		$color_b = $color_b * ($saturation / 255);
		$offset_saturation = 128 * (255 - $saturation) / 255;
		$color_r += $offset_saturation;
		$color_g += $offset_saturation;
		$color_b += $offset_saturation;
	}
	
	#Tried
	$color_r = ((255 - abs($brightness - 255)) / 255);
	$color_g = ((255 - abs($brightness - 255)) / 255);
	$color_b = ((255 - abs($brightness - 255)) / 255);
	
	#format
	$color_r = eval sprintf('%.6f', $color_r);
	$color_g = eval sprintf('%.6f', $color_g);
	$color_b = eval sprintf('%.6f', $color_b);	
}
#It happens that when one exports an obj file as a static mesh
#and decides to use it as an obj_from_mc with basescale1 (ie no scaling)
#this all works out if you have made sure you centred your brush on 0,0,0
#wouldn't think it would because in darkplaces quake1 engine the obj seems to be flipped left to right or something
#but I guess this just worked out it seemed
#it did when I did it by hand
#
#so when you want to export a map to obj in unreal editor 2.1 for old unreal
#what you do is you make a box brush, then center it on 0,0,0 as it's location
#then make it bigger than your level
#then press the intersect button
#it's a box from the bottom going into another box, cyan on top but in bottom corner atop a dark blue one
#    ////////////
#    ..        //
#/////////// B //
#//       // L //
#//       // U //
#// cyan  // E //
#//       //...//
#//       //
#///////////
#then you will have a red outline of the whole map
#save your .unr map to intersectedbrushmap.unr or so
#then open it up again
#now "wrong click" (right click) on the red brush, like a line of it
#then in unreal ed 2.1 you will have a menu pop up
#it will have an option to convert the brush to static mesh
#somewhere in there
#do that, then export it to obj
#then rename the obj somemap.basescale1.obj_from_mc
#now, go back to your original .unr map
#export that as a t3d from the file menu
#that's what this reads
# later alongside the somemap.basescale1.obj_from_mc
# you can have a      somemap.basescale1.ent
# the engine will load that
#
$dostuff = 0;
$endnow = 0;
$classname = "";
$islocationline = 0;
$isrotationline = 0;
$isambientsoundline = 0;
$islight_hueline = 0;
$islight_saturationline = 0;
$islight_brightnessline = 0;
$islightradiusline = 0;
$origin_x = 0;
$origin_y = 0;
$origin_z = 0;
$rotation_pitch = 0; #X looking up down (.angles_x)  (up-down)
$rotation_yaw = 0;  #Y yaw, what way looking side to side (.angles_y), also alone can be .angle (side-side, regular rotation, like a pole rotating)
$rotation_roll = 0; #Z roll, like a barrel (.angles_z)  (like a plane spinning while going forward via changing the flaps on it's wings)
$noise = '';
$originalnoisecomment = '';
$model = '';
$count = '';
$originalclassname = '';
$ignoreingalllinesinbrush = 0;
$hue = 0;
$saturation = 0;
$brightness = 0;
$light_radius = 0;
$color_r = 0;
$color_g = 0;
$color_b = 0;
$spawnflags = 0;
$cubemap = '';
$corona = 0;

$fallbackdatafile = "data2.t3d";
$datafile = '';
$rtlights_add_an_exclaimation_point = 0;


#Accept as input a value for what file to parse
	if (@ARGV[0]) {
		$datafile = @ARGV[0]; #normal
		
		if (@ARGV[0]  eq '--testhsv') {
			test_hsv_to_rgb();
			exit; # allready has an exit
		} elsif (@ARGV[0]  eq '-l') {
			$mode = 1; #lights
			if (@ARGV[1]) {
				$datafile = @ARGV[1];
			} else {
				$datafile = $fallbackdatafile;
			}
		} elsif ((@ARGV[0]  eq '-rt')
			|| (@ARGV[0]  eq '-rt1') 
			|| (@ARGV[0]  eq '-rt2')
			|| (@ARGV[0]  eq '-rt3')
			|| (@ARGV[0]  eq '-rt4')
			|| (@ARGV[0]  eq '-rt5')
			|| (@ARGV[0]  eq '-rt7')
			|| (@ARGV[0]  eq '-rt10')
			|| (@ARGV[0]  eq '-rt15')
			|| (@ARGV[0]  eq '-rt20'))
		{
			#Yes this could be done a cleverer way, 10 is good for most maps, 
			#but some maps are too much for using realtime light
			
			$mode = 2; #rtlights
			if (@ARGV[0]  eq '-rt') {
				#default scale is 10
			} elsif (@ARGV[0]  eq '-rt7') {
				$rtlight_radius_scale = 7;
			} elsif (@ARGV[0]  eq '-rt5') {
				$rtlight_radius_scale = 5;
			} elsif (@ARGV[0]  eq '-rt4') {
				$rtlight_radius_scale = 4;
			} elsif (@ARGV[0]  eq '-rt3') {
				$rtlight_radius_scale = 3;
			} elsif (@ARGV[0]  eq '-rt2') {
				$rtlight_radius_scale = 2;
			} elsif (@ARGV[0]  eq '-rt1') {
				$rtlight_radius_scale = 1;
			} elsif (@ARGV[0]  eq '-rt10') {
				$rtlight_radius_scale = 10;
			} elsif (@ARGV[0]  eq '-rt15') {
				$rtlight_radius_scale = 15;
			} elsif (@ARGV[0]  eq '-rt20') {
				$rtlight_radius_scale = 20;
			}
			
			
			if (@ARGV[1]) {
				$datafile = @ARGV[1];
			} else {
				$datafile = $fallbackdatafile;
			}
			
			if (@ARGV[2] || @ARGV[3]) {
				if (@ARGV[2]  eq '--ex' || @ARGV[3]  eq '--ex') {
					$rtlights_add_an_exclaimation_point = 1;
				}
				if (@ARGV[2]  eq '--ig' || @ARGV[3]  eq '--ig') {
					#ignore unset
					#can strip out lazy mapping lights and give darker better atmosphere to some maps
					$SET_UNSET_LIGHT_COLOR = 0;
					$SET_UNSET_LIGHT_RADIUS = 0;
				} elsif (@ARGV[2]  eq '--setunset' || @ARGV[3]  eq '--setunset') {
					#mutually exclusive to above
					#this is the default, but if you change it above, you can reset it
					$SET_UNSET_LIGHT_COLOR = 1;
					$SET_UNSET_LIGHT_RADIUS = 1;
				}
			}
		}
		
		#normal
		if ($STRICTFILECONTROL) {
			if (index(lc($datafile), lc('.t3d')) != -1) {
				##Happy
			} else {
				die "not .t3d file and strict file control is on";
			}
		}
	} else {
		$datafile = $fallbackdatafile;
	}






open (FILE, "$datafile") || die "can't open file because $!";
while (my $line = <FILE>)
{
	if ($DEBUGPRINTS > 1) {print ("!!!!! $line");}
$thing = $line;
# #The point of this is to iterate through a t3d file and look for things to print in the entity format
# open (FILE, 'data.t3d'); #for data mode
# #while (<FILE>) {         #for data mode
# while (<>) {  #attempt for data mode
# #while (1) {             #for pasting mode

$beforeequals = "";
$afterequals = "";
$islocationline = 0;
$isrotationline = 0;
$islight_hueline = 0;
$islight_saturationline = 0;
$islight_brightnessline = 0;
$islightradiusline = 0;
$isambientsoundline = 0;

# ##$thing = <STDIN>; #for pasting mode
# ##chomp($thing); #for pasting mode
# #$thing = chomp($_); #for data mode
# $thing = <FILE>; #attempt for data mode
# chomp($thing); #attempt for data mode
# #$thing = chomp; #attempt for data mode2
chomp($thing);

	if ($thing eq 'End Actor') {
				if ($DEBUGPRINTS) { print("    **** Says End Actor\n"); }
		$endnow = 1;
		$ignoreingalllinesinbrush = 0;
	} elsif (index(lc($thing), lc('End Actor')) != -1) {
			if ($DEBUGPRINTS) {  print "contains end actor\n"; }
		$endnow = 1;
		$ignoreingalllinesinbrush = 0;
	} elsif ($ignoreingalllinesinbrush == 1) {
			if ($DEBUGPRINTS) {  print("    _____I\n"); }
	} elsif (index(lc($thing), lc('Begin Actor Class=Brush')) != -1) {
			if ($DEBUGPRINTS) {  print "actor class brush wait till past maybe\n"; }
		$ignoreingalllinesinbrush = 1;
	} elsif (index(lc($thing), lc('Begin Actor')) != -1) {
			if ($DEBUGPRINTS) {  print "ignoring begin actor line so does not conflict with ambient sound\n"; }
	} elsif (index(lc($thing), lc('Location')) != -1) {
   				if ($DEBUGPRINTS) {  print "$thing contains Location\n"; }
		$islocationline = 1;
	} elsif (index(lc($thing), lc('Rotation')) != -1) {
   				if ($DEBUGPRINTS) {  print "$thing contains Rotation\n"; }
		$isrotationline = 1;
	} elsif (index(lc($thing), lc('LightHue')) != -1) {
		$islight_hueline = 1;
	} elsif (index(lc($thing), lc('LightSaturation')) != -1) {
		$islight_saturationline = 1;
	} elsif (index(lc($thing), lc('LightBrightness')) != -1) {
		$islight_brightnessline = 1;
	} elsif (index(lc($thing), lc('LightRadius')) != -1) {
		$islightradiusline = 1;
	} elsif (index(lc($thing), lc('AmbientSound')) != -1) {
   				if ($DEBUGPRINTS) {  print "$thing contains AmbientSound\n"; }
		$isambientsoundline = 1;
	} else {
				if ($DEBUGPRINTS) {  print("    _____Nothing\n"); }
		#$dostuff = 0;
	}

	if ($ignoreingalllinesinbrush == 1) {
		if ($DEBUGPRINTS) {  print("    _____IgnoringBrush\n"); }
	} elsif ($islocationline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS) {  print("AFTEREQUALSLOCATIONLINE   ***$afterequals\n"); }
		$afterequals =~ s/\(//;
		$afterequals =~ s/\)//;
				if ($DEBUGPRINTS) {  print("                      2   ***$afterequals\n\n\n"); }
			
		
		$origin_x = 0;
		$origin_y = 0;
		$origin_z = 0;
		
		@tokens = split(/,/, $afterequals);
		foreach my $token (@tokens) {
		    		if ($DEBUGPRINTS) {  print("$token\n"); }
		    ($beforeequals, $afterequals) = split("=",$token,2);
		   		if ($DEBUGPRINTS) {   print("	$beforeequals\n"); }
		   		if ($DEBUGPRINTS) {   print("	$afterequals\n"); }
				
				#Getrid of whitespaces etc to get rid of carraigertrn ##
				$afterequals =~ s/\A\s+//s;                           ##
    				$afterequals =~ s/\s+\Z//s;                           ##
				#Getrid of whitespaces etc to get rid of carraigertrn ##
			
		    if ($beforeequals eq 'X') {
		    	$origin_x = $afterequals;
		    } elsif ($beforeequals eq 'Y') {
		    	$origin_y = $afterequals;
		    } elsif ($beforeequals eq 'Z') {
		    	$origin_z = $afterequals;
		    }
		}
	} elsif ($isrotationline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS) {  print("AFTEREQUALSROTATIONLINE   ***$afterequals\n"); }
		$afterequals =~ s/\(//;
		$afterequals =~ s/\)//;
				if ($DEBUGPRINTS) {  print("                      2   ***$afterequals\n\n\n"); }
			
		
		$rotation_pitch = 0;
		$rotation_yaw = 0;
		$rotation_roll = 0;
		
		@tokens = split(/,/, $afterequals);
		foreach my $token (@tokens) {
		    		if ($DEBUGPRINTS) {  print("$token\n"); }
		    ($beforeequals, $afterequals) = split("=",$token,2);
		   		if ($DEBUGPRINTS) {   print("	$beforeequals\n"); }
		   		if ($DEBUGPRINTS) {   print("	$afterequals\n"); }
				
				#Getrid of whitespaces etc to get rid of carraigertrn ##
				$afterequals =~ s/\A\s+//s;                           ##
    				$afterequals =~ s/\s+\Z//s;                           ##
				#Getrid of whitespaces etc to get rid of carraigertrn ##
			
		    if ($beforeequals eq 'Pitch') {
		    	$rotation_pitch = $afterequals;
		    } elsif ($beforeequals eq 'Yaw') {
		    	$rotation_yaw = $afterequals;
		    } elsif ($beforeequals eq 'Roll') {
		    	$rotation_roll = $afterequals;
		    }
		}
	} elsif ($isambientsoundline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS)  { print("ESASAFTEREQUALSAMBIENTSOUND  ***$afterequals\n"); }
		$afterequals =~ s/Sound\'//;
		$afterequals =~ s/\'//;
				if ($DEBUGPRINTS)  { print("                      2   ***$afterequals\n\n\n"); }
		
		
		$noise = '';
		#$noise = chomp($afterequals);
			#Getrid of whitespaces etc to get rid of carraigertrn ##
			$afterequals =~ s/\A\s+//s;                           ##
    			$afterequals =~ s/\s+\Z//s;                           ##
			#Getrid of whitespaces etc to get rid of carraigertrn ##
		$noise = $afterequals;
		
		
			if ($CONVERT_SOME_NOISES_TO_SIMPLER_STRING) {
				if ($PRINTORIGINALSOUNDINFOASCOMMENTIFCONVERTED) {
					$originalnoisecomment = $afterequals;
				}
				$afterequals =~ s/Ambancient\.Looping\.//;
				$afterequals =~ s/Ambmodern\.Looping\.//;
				$afterequals =~ s/Amboutside\.Looping\.//;
				$afterequals =~ s/AmbModern\.Looping\.//;
				$afterequals =~ s/ambientmusic\.Package0\.//;
				$afterequals =~ s/urbansnds\.\(All\)\.//;
				$noise = 'sound/UNR_'."$afterequals";
			}
		
		if ($dostuff == 4) { 
			$dostuff = 7; 
			$classname = 'target_speaker'; 
		} #Change to ambient sound part instead
	} elsif ($islight_hueline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS)  { print("ESASAFTEREQUALSHUE  ***$afterequals\n"); }
		$hue = 0;
			#Getrid of whitespaces etc to get rid of carraigertrn ##
			$afterequals =~ s/\A\s+//s;                           ##
    			$afterequals =~ s/\s+\Z//s;                           ##
			#Getrid of whitespaces etc to get rid of carraigertrn ##
		$hue = $afterequals;
	} elsif ($islight_saturationline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS)  { print("ESASAFTEREQUALSSATURATION  ***$afterequals\n"); }
		$saturation = 0;
			#Getrid of whitespaces etc to get rid of carraigertrn ##
			$afterequals =~ s/\A\s+//s;                           ##
    			$afterequals =~ s/\s+\Z//s;                           ##
			#Getrid of whitespaces etc to get rid of carraigertrn ##
		$saturation = $afterequals;
		$hue = $afterequals;
	} elsif ($islight_brightnessline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS)  { print("ESASAFTEREQUALSBRIGHTNESS  ***$afterequals\n"); }
		$brightness = 0;
			#Getrid of whitespaces etc to get rid of carraigertrn ##
			$afterequals =~ s/\A\s+//s;                           ##
    			$afterequals =~ s/\s+\Z//s;                           ##
			#Getrid of whitespaces etc to get rid of carraigertrn ##
		$brightness = $afterequals;
	} elsif ($islightradiusline) {
		($beforeequals, $afterequals) = split("=",$thing,2);
				if ($DEBUGPRINTS)  { print("ESASAFTEREQUALSLIGHTRADIUS  ***$afterequals\n"); }
		$light_radius = 0;
			#Getrid of whitespaces etc to get rid of carraigertrn ##
			$afterequals =~ s/\A\s+//s;                           ##
    			$afterequals =~ s/\s+\Z//s;                           ##
			#Getrid of whitespaces etc to get rid of carraigertrn ##
		$light_radius = $afterequals;
	} else {
		#($beforeequals, $afterequals) = split("=",$thing,2);
		($beforeequals, $afterequals) = split("=",$thing);
		#print("   ***$beforeequals\n\n\n");
						if ($DEBUGPRINTS)  { print("   ***$afterequals\n\n\n"); }
		
		if ($beforeequals eq 'Begin Actor Class') {
			$classname = "";
						if ($DEBUGPRINTS)  { print("    **** Eays Begin Actor Class\n"); }
			$TWObeforespace = "";
			$TWOafterspace = "";
			
			#($TWObeforespace, $TWOafterspace) = split("\s+",$afterequals,2);
			#($TWObeforespace, $TWOafterspace) = split("/x",$afterequals,2);
			($TWObeforespace, $TWOafterspace) = split(" Name",$afterequals,2); #hack
			$classname = $TWObeforespace;
				$originalclassname = $classname; #record
				
				#Light mode
				if (($mode == 1 || $mode == 2) && $classname eq 'Light')  {
					#$classname = 'fullydynamic';
					$classname = 'item_cells';$spawnflags= 1;
					$classname = 'lightsabre_spawnlight';
					#$classname = 'not_null'; #doesn't work with not null
					#$classname = 'info_notnull';  #doesn't work either
					   #some tests	
						#$cubemap = 'somecubemapsomewhere';
						#$corona = 10;
					$dostuff = 1000; #special generic
				} elsif ($mode == 1 || $mode == 2) {
					#ignore everything else 
				
				} 
				#Normal mode
				elsif ($classname eq 'Light')
					{
						$dostuff = 4;
					}
				elsif ($classname eq 'RocketCan')
					{
						$classname = 'item_rockets';
						$dostuff = 5;
					}
				elsif ($classname eq 'Eightball')
					{
						$classname = 'weapon_ballrktlauncher';
						$dostuff = 5;
					}
				elsif ($classname eq 'Sludge')
					{
						$classname = 'item_toxic';
						$dostuff = 5;
					}
				elsif ($classname eq 'GESBioRifle')
					{
						$classname = 'weapon_gbserifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'Minigun')
					{
						$classname = 'weapon_cmbn9mgun';
						$dostuff = 5;
					}
				elsif ($classname eq 'AutoMag')
					{
						$classname = 'weapon_pistol';
						$dostuff = 5;
					}
				elsif ($classname eq 'Shellbox')
					{
						$classname = 'item_bullets';
						$dostuff = 5;
					}
				elsif ($classname eq 'Rifle')
					{
						$classname = 'weapon_t17mmrifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'RifleRound')
					{
						$classname = 'item_bullets';
						$dostuff = 6; #special case, more information printed
					}
				elsif ($classname eq 'Razorjack') #not tested
					{
						$classname = 'weapon_razorprjctr';
						$dostuff = 5;
					}
				elsif ($classname eq 'DispersionPistol') #not tested
					{
						$classname = 'weapon_dsprsnpstl';
						$dostuff = 5;
					}
				elsif ($classname eq 'ASMD')
					{
						$classname = 'weapon_asdwrifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'ASMDAmmo')
					{
						$classname = 'item_cells';
						$dostuff = 5;
					}
				elsif ($classname eq 'Armor')
					{
						$classname = 'item_armor';
						$dostuff = 5;
					}
				elsif ($classname eq 'NaliFruit')
					{
						$classname = 'item_health_small';
						$dostuff = 5;
					}
				elsif ($classname eq 'SuperHealth')
					{
						$classname = 'item_health_mega';
						$dostuff = 5;
					}
				elsif ($classname eq 'FlakCannon')
					{
						$classname = 'weapon_fragmentationcannon';
						$dostuff = 5;
					}
				elsif ($classname eq 'Stinger')
					{
						$classname = 'weapon_strkr';
						$dostuff = 5;
					}
				elsif ($classname eq 'PlayerStart')
					{
						$classname = 'info_player_start';
						$dostuff = 5;
						if ($ENABLE_ADD_Z_TOPLAYERSTART) {
							if ($add_z_toplayerstart) {
								$dostuff = 500;
							}
						}
					}
				elsif ($classname eq 'AmbientSound')
					{
						$classname = 'target_speaker';
						$dostuff = 7;	#needs more info pasted
					}
				elsif ($classname eq 'PulseGun') #not tested
					{
						$classname = 'weapon_electricrifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'UT_Eightball') #not tested
					{
						$classname = 'weapon_nineballlauncher';
						$dostuff = 5;
					}
				#ammo substitutions
				elsif ($classname eq 'FlakBox') #ammo substitutions
					{
						$classname = 'item_rockets';
						$dostuff = 5;
					}
				elsif ($classname eq 'StingerAmmo') #ammo substitutions
					{
						$classname = 'item_cells';
						$dostuff = 5;
					}
				elsif ($classname eq 'RifleAmmo') #ammo substitutions
					{
						$classname = 'item_bullets';
						$dostuff = 5;
					}
				#substitutions
				elsif ($classname eq 'UT_FlakCannon') #not tested #substitutions
					{
						$classname = 'weapon_fragmentationcannon';
						$dostuff = 5;
					}
				elsif ($classname eq 'Ripper') #not tested #substitutions
					{
						$classname = 'weapon_razorprjctr';
						$dostuff = 5;
					}
				elsif ($classname eq 'ShockRifle') #not tested #substitutions
					{
						$classname = 'weapon_asdwrifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'Enforcer') #not tested #substitution... sort of
					{
						$classname = 'weapon_pistol';
						$dostuff = 5;
					}
				elsif ($classname eq 'UT_BioRifle') #not tested #substitutions
					{
						$classname = 'weapon_gbserifle';
						$dostuff = 5;
					}
				elsif ($classname eq 'SniperRifle') #not tested #substitutions
					{
						$classname = 'weapon_lrr';
						$dostuff = 5;
					}
				elsif ($classname eq 'Minigun2') #not tested 
					{
						$classname = 'weapon_minigunii';
						$dostuff = 5;
					}
				elsif ($classname eq 'WarheadLauncher') #not tested 
					{
						$classname = 'weapon_rdmrrocket';
						$dostuff = 5;
					}
				#Others
				elsif ($classname eq 'SU_1911')
					{
						$classname = 'weapon_bigpistol';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_MP5')
					{
						$classname = 'weapon_pdw';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Aug')
					{
						$classname = 'weapon_styeraug';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Ithaca')
					{
						$classname = 'weapon_ithacastakeout';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Glock')
					{
						$classname = 'weapon_lightpistol';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_RPG7') 
					{
						$classname = 'weapon_rpg7launcher';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Rem308') #substitution
					{
						$classname = 'weapon_m1903';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Grenade') 
					{
						$classname = 'item_fragnades';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Vest') #substitution
					{
						$classname = 'item_armor_large';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Jacket') #substitution
					{
						$classname = 'item_health_small';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_Can') #substitution #guess
					{
						$classname = 'item_rockets';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_AmmoCan9mm') #substitution
					{
						$classname = 'item_bullets';
						$dostuff = 5;
					}
				elsif ($classname eq 'SU_AmmoSingle308')
					{
						$classname = 'item_bullets';
						$dostuff = 7; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoLooseShells')
					{
						$classname = 'item_shells';
						$dostuff = 8; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoClips223')
					{
						$classname = 'item_bullets';
						$dostuff = 9; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoBox9mm')
					{
						$classname = 'item_bullets';
						$dostuff = 10; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoClips45') #substitution
					{
						$classname = 'item_bullets';
						$dostuff = 11; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoLoose308') #substitution
					{
						$classname = 'item_bullets';
						$dostuff = 12; #special case, more information printed
					}
				
				elsif ($classname eq 'SU_AmmoBox45')
					{
						$classname = 'item_bullets';
						$dostuff = 15; #special case, more information printed
					}
				elsif ($classname eq 'SU_AmmoBoxShells') #substitution
					{
						$classname = 'item_shells';
						$dostuff = 5; 
					}
				elsif ($classname eq 'SteelBox') #substitution
					{
						$classname = 'building_buildable_by_count';
						$dostuff = 200; 
						$count = 1772; #MTB64U_METAL
					}
				elsif ($classname eq 'SteelBarrel') #guess 
					{
						$classname = 'building_buildable_by_count';
						$dostuff = 200; 
						$count = 1819; #MTB64U_INACT_OIL
					}
				elsif ($classname eq 'TarydiumBarrel') #substitution
					{
						$classname = 'building_buildable_by_count';
						$dostuff = 200; 
						$count = 1820; #MTB64U_ACT_OIL
					}
				#elsif ($classname eq 'ImpactHammer') #not tested 
				elsif ($classname eq 'NaliStatue')
					{
						$classname = 'func_wall';
						$dostuff = 100; #special case for models, more information printed
						$model = 'models/fromunreal/NaliStatueM_fortundra.basescale1.obj_from_mc';
					
						$dostuff = 1000; #special generic
					} 
				elsif ($classname eq 'Tapestry1')
					{
						$classname = 'func_wall';
						$dostuff = 100; #special case for models, more information printed
						$model = 'models/fromunreal/Tap_fortundra.basescale1.obj_from_mc';
					
						$dostuff = 1000; #special generic
					}
				else 
					{
						if ($IGNOREPATHNODES && ($classname eq 'PathNode')) {
							#nothing
						} elsif ($IGNORELEVELINFO && ($classname eq 'LevelInfo')) {
							#nothing
						} elsif ($IGNOREZONEINFO && ($classname eq 'ZoneInfo')) {
							#nothing
						} else {
					$dostuff = 3;
						}
						$originalclassname = ''; #reset it
				}
		}
	}

#Ignore if in brush
if ($ignoreingalllinesinbrush == 1) {
#First a test massage
} elsif ($dostuff == 3 && $endnow == 1 && $TESTUNKNOWNPRINTS) {
	if ($COMMENTOUTUNKNOWNSIFTESTUNKNOWNPRINTS) {
print('//'); print('#'); print('ee'); print('{'); print("\n");
print('//'); print('#'); print('ee'); print('	classname "'); print("$classname"); print('"');print(' xxxxxx'); 
		if ($ORIGINFORUNKNOWNSIFTESTUNKNOWNPRINTS == 1) {
		print("\t\t"); print('//'); print('#');  print(int($origin_x), ' ',  int($origin_y), ' ', int($origin_z));
		}print("\n");
print('//'); print('#'); print('ee'); print('}'); print("\n");
		if ($ORIGINFORUNKNOWNSIFTESTUNKNOWNPRINTS == 2) {
		print('//'); print('#'); print('Above Location:'); print(($origin_x), ' ',  ($origin_y), ' ', ($origin_z)); print("\n");
		}
	} else {
my $message = <<"END_MESSAGE";
ee{
ee	classname "$classname" xxxxxx
ee}
END_MESSAGE
print $message;
	}

 newlinebetweensections();
$classname = "";
#then another test message
} elsif ($dostuff == 4 && $endnow == 1 && $TESTLIGHTPRINTS) {
my $message = <<"ENX_MESSAGE";
**{
**	"classname" "$classname" xxxxxx
**	"origin" "$origin_x $origin_y $origin_z"
**	"spawnflags" "1" wonder what that does to a light
**}
ENX_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";
#this is the real deal below
} elsif ($dostuff == 5 && $endnow == 1) {
my $message = <<"ENY_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
}
ENY_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";
#this is for ambientsounds below
} elsif ($dostuff == 7 && $endnow == 1) {
my $message = <<"ENZ_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"noise" "$noise.wav"
}
ENZ_MESSAGE
 
print $message;
	if ($CONVERT_SOME_NOISES_TO_SIMPLER_STRING) {
		if ($PRINTORIGINALSOUNDINFOASCOMMENTIFCONVERTED) {
		print('//');
		print('#');
		print('  Above:');
		print("$originalnoisecomment");
		print("\n");
		}
	}
	 newlinebetweensections();
$classname = "";
#this is the real deal below but a special case for playerstarts if you want to add more Z 
} elsif ($dostuff == 500 && $endnow == 1) {
	if ($PRINTINFOREGARDINGADDINGZTOPLAYERSTART) {
	print('//'); print('#'); print('NOTE Added to Z Below: Original X Y Z:'); print("$origin_x $origin_y $origin_z"); print("\n");
	}
$origin_z = $origin_z + $add_z_toplayerstart;
my $message = <<"ENY_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
}
ENY_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";
#This is a special case for a rifle round for the t17mmrifle
} elsif ($dostuff == 6 && $endnow == 1) {
my $message = <<"ENX2_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/items/casingriflebullet.iqm"
	"scale" "1.46"
	"ammo_nails" "3"
}
ENX2_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";





#This is a special case for a rifle round for the rem308
} elsif ($dostuff == 7 && $endnow == 1) {
my $message = <<"ENX3_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/items/casingriflebullet.iqm"
	"scale" "0.66"
	"ammo_nails" "3"
}
ENX3_MESSAGE
print $message; newlinebetweensections();
$classname = "";


#This is a special case for shells for ithaca, should be 12 ga, but scale set to 8ga for now since it's a bunch of them
} elsif ($dostuff == 8 && $endnow == 1) {
my $message = <<"ENX5_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/casing_shell.mdl"
	"scale" "1.145"
	"ammo_shells" "3"
}
ENX5_MESSAGE
print $message; newlinebetweensections();
$classname = "";

#This is a special case for a clip of 223 //Scale big to distinguish from the pickup
} elsif ($dostuff == 9 && $endnow == 1) {
my $message = <<"ENX7_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/misc/extendedmags/styeraugmag30.iqm"
	"scale" "2"
	"ammo_nails" "30"
}
ENX7_MESSAGE
print $message; newlinebetweensections();
$classname = "";



#This is a special case for a box of 9mm //Scale down ammo can?
} elsif ($dostuff == 10 && $endnow == 1) {
my $message = <<"ENX10_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"scale" "0.66"
	"ammo_nails" "60"
}
ENX10_MESSAGE
print $message; newlinebetweensections();
$classname = "";


#This is a special case for a clips of 45 //Scale up to distinguish from the pickup
} elsif ($dostuff == 11 && $endnow == 1) {
my $message = <<"ENX11_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/misc/extendedmags/uzimag20.iqm"
	"scale" "2"
	"ammo_nails" "12"
}
ENX11_MESSAGE
print $message; newlinebetweensections();
$classname = "";


#This is a special case for loose 203 //Scale up to distinguish from the pickup
} elsif ($dostuff == 12 && $endnow == 1) {
my $message = <<"ENX12_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"model" "models/casing_steel.mdl"
	"scale" "2"
	"ammo_nails" "3"
}
ENX12_MESSAGE
print $message; newlinebetweensections();
$classname = "";


#This is a special case for a box of 45 //Scale down ammo can?
} elsif ($dostuff == 15 && $endnow == 1) {
my $message = <<"ENX15_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"spawnflags" "1"
	"scale" "0.75"
	"ammo_nails" "70"
}
ENX15_MESSAGE
print $message; newlinebetweensections();
$classname = "";


#This is a special case for a buildablebuildingnumber by count
} elsif ($dostuff == 200 && $endnow == 1) {
my $message = <<"COUNT0_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"count" "$count"
}
COUNT0_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";

#This is a special case for a model
} elsif ($dostuff == 100 && $endnow == 1) {
my $message = <<"MODEL0_MESSAGE";
{
	"classname" "$classname"
	"origin" "$origin_x $origin_y $origin_z"
	"model" "$model"
}
MODEL0_MESSAGE
 
print $message; newlinebetweensections();
$classname = "";
#This is a special generic case
} elsif ($dostuff == 1000 && $endnow == 1) {
	if ($mode == 2) { #rtlight
		#origin 20, -36, -240 .... radius 200 , red (1 0 0)
		#20.000000 -36.000000 -240.000000 200.000000 1.000000 0.000000 0.000000 0
		#angles 10, 90, 20
		#20.000000 -36.000000 -240.000000 200.000000 1.000000 1.000000 1.000000 0 "" 0.000000 10.000000 90.000000 20.000000
		#style 3
		#20.000000 -36.000000 -240.000000 200.000000 1.000000 1.000000 1.000000 3
		##if (!($hue)) { $hue = 64 }		#set defaults if not set
		##if (!($saturation)) { $saturation = 255}#set defaults if not set
		hsv_to_rgb();
		if ((!($color_r)) && (!($color_b)) && (!($color_g))) 
		{
			if ($SET_UNSET_LIGHT_COLOR) {
			$color_r = 1;
			$color_g = 1;
			$color_b = 1;
			}
		}
		if ($rtlights_add_an_exclaimation_point) {print '!';}
		print(sprintf('%.6f', $origin_x)); print ' ';
		print(sprintf('%.6f', $origin_y)); print ' ';
		print(sprintf('%.6f', $origin_z)); print ' ';
			if (!($light_radius)) { if ($SET_UNSET_LIGHT_RADIUS) { $light_radius = 64; } } #default
			if ($rtlight_radius_scale) { 
				print(sprintf('%.6f', $light_radius*$rtlight_radius_scale)); 
			} else { 
				print(sprintf('%.6f', $light_radius)); 
			} print ' ';
		print(sprintf('%.6f', $color_r)); print ' ';
		print(sprintf('%.6f', $color_g)); print ' ';
		print(sprintf('%.6f', $color_b)); print ' ';
		print '0'; print ' '; #style
		if ($rotation_pitch || $rotation_yaw || $rotation_roll || $cubemap || $corona) {
			print ('"'); print("$cubemap"); print('"'); print ' '; #cubemap
			
			if ($rotation_pitch || $rotation_yaw || $rotation_roll || $corona) {
				print(sprintf('%.6f', $corona)); print ' '; #?corona
			
				if ($rotation_pitch || $rotation_yaw || $rotation_roll) {
					if ($rotation_pitch) { $rotation_pitch = &rotation_convert($rotation_pitch); }
					if ($rotation_yaw) { $rotation_yaw = &rotation_convert($rotation_yaw); }
					if ($rotation_roll) { $rotation_roll = &rotation_convert($rotation_roll); }
					print(sprintf('%.6f', $rotation_pitch)); print ' ';
					print(sprintf('%.6f', $rotation_yaw)); print ' ';
					print(sprintf('%.6f', $rotation_roll)); print ' ';
				}
			}
		}
		print "\n";
	} elsif ($classname) {
		$comment_out_noise = 0;
		if ($rotation_pitch || $rotation_yaw || $rotation_roll) {
			if ($PRINTORIGINALROTATIONINFOASCOMMENTIFCONVERTED) {
			print('//');
			print('#');
			print('  Below: Rotation Pre Conversions ');
			print("Pitch $rotation_pitch  Yaw $rotation_yaw  Roll$rotation_roll");
			print("\n");
			}
			if ($rotation_pitch) { $rotation_pitch = &rotation_convert($rotation_pitch); }
			if ($rotation_yaw) { $rotation_yaw = &rotation_convert($rotation_yaw); }
			if ($rotation_roll) { $rotation_roll = &rotation_convert($rotation_roll); }
		}
		
		if ($hue || $saturation || $brightness) {
			$comment_out_noise = 1;
			if ($PRINTORIGINALHUESATURATIONBRIGHTNESSINFOASCOMMENTIFCONVERTED) {
			print('//');
			print('#');
			print('  Below: HSV Pre Conversions ');
			print("Hue $hue  Saturation $saturation  Brightness $brightness\n");
			}
		}
		
		
	print('{'); print("\n");
		#print our classname, which will be the subroutine that is called or so in game
			print("\t",'"','classname','"',' '); print('"',"$classname",'"'); print("\n");
		#origin
		if ($origin_x || $origin_y || $origin_z) {
			print("\t",'"','origin','"',' '); print('"',"$origin_x $origin_y $origin_z",'"'); print("\n");
		}
		if ($model) {
			print("\t",'"','model','"',' '); print('"',"$model",'"'); print("\n");
		}
		#rotation if only around then just angle, otherwise use vector angles
		if ($rotation_yaw && !($rotation_pitch) && !($rotation_roll)) {
			print("\t",'"','angle','"',' '); print('"',"$rotation_yaw",'"'); print("\n");
		} elsif ($rotation_pitch || $rotation_yaw || $rotation_roll) {
			print("\t",'"','angles','"',' '); print('"',"$rotation_pitch $rotation_yaw $rotation_roll",'"'); print("\n");
		}
		if ($noise) {
			if ($comment_out_noise) {
			print("\t");
			print('//');
			print('#');
			}
			print("\t",'"','noise','"',' '); print('"',"$noise.wav",'"'); print("\n");
		}
		if ($light_radius) {
			print("\t",'"','light_lev','"',' '); print('"',"$light_radius",'"'); print("\n");
		}
		if ($spawnflags) {
			print("\t",'"','spawnflags','"',' '); print('"',"$spawnflags",'"'); print("\n");
		}
		###set defaults 
		##if ($mode == 1) { #lm mode
		##	if (!($hue)) { $hue = 64 }		#set defaults if not set
		##	if (!($saturation)) { $saturation = 255}#set defaults if not set
		##} #will be in time for next part
		if (($hue || $saturation || $brightness) || ($mode == 1)) {
			hsv_to_rgb();
			if ((!($color_r)) && (!($color_b)) && (!($color_g))) 
			{
				if ($SET_UNSET_LIGHT_COLOR) {
				$color_r = 1;
				$color_g = 1;
				$color_b = 1;
				}
			}
			print("\t",'"','color','"',' '); print('"',"$color_r $color_g $color_b",'"'); print("\n");
			print("\t",'"','pflags','"',' '); print('"','128','"'); print("\n"); #PFLAGS_FULLDYNAMIC
			print("\t",'"','style','"',' '); print('"','0','"'); print("\n");
			
			#set default light radius if none as above in the rt code
			if (!($light_radius)) { 
				if ($SET_UNSET_LIGHT_RADIUS) {
				$light_radius = 64;
				print("\t",'"','light_lev','"',' '); print('"',"$light_radius",'"'); print("\n");	
				}
			} #default
		}
	print('}'); print("\n");
	
		if ($PRINTORIGINALHUESATURATIONBRIGHTNESSINFOASCOMMENTIFCONVERTED) {
			if ($hue || $saturation || $brightness) {
			print('//');
			print('#');
			print('  Above: Color ');
			print(int($color_r*256),' ', int($color_g*256),' ',  int($color_b*256),' ');
			print("\n");
			}
		}
		
		if ($CONVERT_SOME_NOISES_TO_SIMPLER_STRING) {
			if ($PRINTORIGINALSOUNDINFOASCOMMENTIFCONVERTED) {
			if ($noise) {
			print('//');
			print('#');
			print('  Above:');
			print("$originalnoisecomment");
			print("\n");
			}
			}
		}
		newlinebetweensections();
	}
$classname = "";
}
#completed

	#reset variables for the next block
	if ($endnow == 1) {
		$classname = "";
		$beforeequals = "";
		$afterequals = "";
		$endnow = 0;
		$dostuff = 0;
		$origin_x = 0;
		$origin_y = 0;
		$origin_z = 0;
		$rotation_pitch = 0;
		$rotation_yaw = 0; 
		$rotation_roll = 0; 
		$noise = '';
		$model = '';
		$count = '';
		$originalnoisecomment = '';
		$originalclassname = '';
		$hue = 0;
		$saturation = 0;
		$brightness = 0;
		$light_radius = 0;
		$color_r = 0;
		$color_g = 0;
		$color_b = 0;
		$spawnflags = 0;
		$cubemap = '';
		$corona = 0;
	}

}

if ($mode == 2) {
	#leave blank
	if ($PRINTCOMMANDARGUMENTSFORRTLIGHTS) {
	print('//');
	print('#');
	print(' Command arguments used: ');
	print("@ARGV");
	print("\n");
	}
} else {
print("//#FINISHED FILE\n");
}

close (FILE); #for data mode
exit;	      #for data mode
